
******************************************************************
*
* Categorical Treatment Variable (using an artificial dataset)
*
* JOSEF BRDERL, LMU, February 2015
*
******************************************************************

* These are the variables in the dataset:
* id       person identifier
* time     # panel wave
* wage     monthly wage in Euro
* wage_01  monthly wage in Euro (variant of "wage")
* reltyp   type of relationship (0=single, 1=LAT, 2=cohabitation)


*************************************
** Preliminaries    *****************
*************************************
clear 
set more off

* Load data
cd  "K:\Vorlesung PDA\Stata Beispiele\Artificial Data\"    //Adapt this path!
use "Cat Treatment.dta", clear

***** Declare data to be panel data *****
xtset id time


******************************************
* No Effect Heterogeneity - No Problem
******************************************
twoway  (scatter wage_01 time, ylabel(0(1000)5000, grid angle(0))            ///
                 ymtick(500(1000)4500, grid) c(L))                           ///
        (scatter wage_01 time if reltyp==1, c(L))                            ///
        (scatter wage_01 time if reltyp==2, c(L) mcolor(blue) lcolor(blue)), ///
		legend(row(1) pos(6) ring(0) label(1 "single") label(2 "LAT") label(3 "Cohabitation"))

xtreg wage_01 i.reltyp, fe                   // all pyrs
est store FE1

xtreg wage_01 i.reltyp  if reltyp<2, fe      // single --> LAT
est store FE2

xtreg wage_01 i.reltyp  if reltyp>0, fe      // LAT --> Cohabitation
est store FE3

estimates table FE1 FE2 FE3, b(%5.0f) star stfmt(%6.0f) stats(N N_g) ///
                keep(1.reltyp 2.reltyp)



******************************************
* Effect Heterogeneity - Problem
******************************************
twoway  (scatter wage time, ylabel(0(1000)5000, grid angle(0))             ///
                 ymtick(500(1000)4500, grid) c(L))                         ///
        (scatter wage time if reltyp==1, c(L))                             ///
        (scatter wage time if reltyp==2, c(L) mcolor(blue) lcolor(blue)),  ///
		legend(row(1) pos(6) ring(0) label(1 "single") label(2 "LAT") label(3 "Cohabitation"))

xtreg wage i.reltyp, fe                   // all pyrs
est store FE1

xtreg wage i.reltyp  if reltyp<2, fe      // single --> LAT
est store FE2

xtreg wage i.reltyp  if reltyp>0, fe      // LAT --> Cohabitation
est store FE3

estimates table FE1 FE2 FE3, b(%5.0f) star stfmt(%6.0f) stats(N N_g) ///
                keep(1.reltyp 2.reltyp)
